@extends('admin.layout.master')

@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/vendors/css/tables/datatable/extensions/dataTables.checkboxes.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/css-rtl/pages/data-list-view.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/css-rtl/core/colors/palette-gradient.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">

@endsection

@section('content')
    {{-- table --}}
    <x-admin.table filter="true">
        <x-slot name="tableHead">
            <th>{{ awtTrans('رقم الطلب') }}</th>
            <th>{{ awtTrans('التاريخ') }}</th>
            <th>{{ awtTrans('السعر') }}</th>
            <th>{{ __('admin.order_procedures') }}</th>
            <th>{{ awtTrans('الحاله') }}</th>
            <th>{{ awtTrans('التحكم') }}</th>
        </x-slot>
        <x-slot name="tableBody">
            @foreach ($settlements as $settlement)
                <tr class="delete_order">
                    <td>{{ $settlement->id }}</td>
                    <td>{{ \Carbon\Carbon::parse($settlement->created_at)->format('d/m/Y') }}</td>
                    <td>{{ $settlement->total_price??''}}</td>
                    <td>
                        @if ($settlement->status == 'pending')
                            <button type="button" class="btn btn-sm btn-success accept-btn" data-toggle="modal"
                                    data-target="#acceptModal"  data-id="{{ $settlement->id }}"
                                    data-amount="{{ $settlement->total_price }}" title="{{ __('admin.accept_order') }}">
                                <i class="fa fa-check" style="color: white"></i>
                            </button>
                            <button type="button" class="btn btn-sm btn-danger cancel-btn" data-toggle="modal"
                                    data-target="#cancelModal" data-id="{{ $settlement->id }}" title="{{ __('admin.refuse_order') }}">
                                <i class="fa fa-times" style="color: white"></i>
                            </button>
                        @elseif($settlement->status =='accepted')
                        -----------------
                        @elseif($settlement->status =='refused')
                            -----------------
                        @endif
                    </td>
                    <td>{{ __('admin.status_' . $settlement->status) }}</td>
                    <td class="product-action">
                        <span class="text-primary"><a href="{{ route('admin.settlements.show', ['id' => $settlement->id]) }}"><i
                                        class="feather icon-eye"></i></a></span>
                    </td>
                </tr>
            @endforeach
        </x-slot>
    </x-admin.table>
    @foreach ($settlements as $settlement)
        @if($settlement->status == 'pending')
        @include('admin.settlements.accept_modal')
        @include('admin.settlements.cancel_modal')
        @include('admin.shared.addImage')
    @endif
    @endforeach
        @endsection

        @section('js')
            <script
                    src="{{ asset('admin/app-assets/vendors/js/tables/datatable/datatables.min.js') }}">
            </script>
            <script
                    src="{{ asset('admin/app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}">
            </script>
            {{--  <script src="{{ asset('admin/app-assets/js/scripts/ui/data-list-view.js') }}"></script>--}}
            <script src="{{asset('admin/datatable_custom.js')}}"></script>
            <script src="{{asset('admin/search.js')}}"></script>
            <script
                    src="{{ asset('admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js') }}">
            </script>
            <script src="{{ asset('admin/app-assets/js/scripts/extensions/sweet-alerts.js') }}">
            </script>
            <script>
                $(document).ready(function(){
                    $('#cancelModal').on('show.bs.modal', function (event) {
                        var button = $(event.relatedTarget); // Button that triggered the modal
                        var id = button.data('id'); // Extract info from data-* attributes
                        var modal = $(this);
                        modal.find('.settlement_id').val(id);
                    });
                });
            </script>
            <script>
                $(document).on('click', '.accept-btn', function() {
                    var id = $(this).data('id'),
                        amount = $(this).data('amount')
                    $('.settlement_id').val(id)
                    $('#amount').val(amount)
                });

                $(document).on('click', '.cancel-btn', function() {
                    var id = $(this).data('id')
                    var status = $(this).data('status')
                    $('.settlement_id').val(id)
                    $('#status').val(status)
                });
            </script>

        @endsection
